#include "HX711.h"

#define DOUT  26
#define CLK  25

HX711 scale;

float calibration_factor = -7050; // initial calibration factor DOES NOT CHANGE FROM CALIBRATION PROCESS YOU MUST HARDCODE THE INITIAL CALIBRATION FACTOR

void setup() {
  Serial.begin(9600);
  Serial.println("HX711 calibration sketch");
  Serial.println("Remove all weight from scale");
  Serial.println("After readings begin, place known weight on scale");
  Serial.println("Press + or a to increase calibration factor"); // enter as many 'a's as you would like to increase the factor on the serial monitor, then press enter
  Serial.println("Press - or z to decrease calibration factor"); // see above

  scale.begin(DOUT, CLK);
  scale.set_scale();
  scale.tare(); //Reset the scale to 0

  long zero_factor = scale.read_average(); //Get a baseline reading
  Serial.print("Zero factor: "); //This can be used to remove the need to tare the scale. Useful in permanent scale projects.
  Serial.println(zero_factor);
}

void loop() {

  scale.set_scale(calibration_factor); //Adjust to this calibration factor

  Serial.print("Reading: ");
  Serial.print(scale.get_units(), 1);
  Serial.print(" g"); //Can change this to kg or N and re-adjust the calibration factor
  Serial.print(" calibration_factor: ");
  Serial.print(calibration_factor);
  Serial.println();

  if(Serial.available())
  {
    char temp = Serial.read();
    if(temp == '+' || temp == 'a')
      calibration_factor += 10;
    else if(temp == '-' || temp == 'z')
      calibration_factor -= 10;
  }
}
